/*
 * Decompiled with CFR 0.152.
 */
package com.maksupay.paysdk;

import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;

public class RSAKeyLoader {
    public static final String SHA256withRSA = "SHA256withRSA";
    public static final String SHA512withRSA = "SHA512withRSA";

    public static PrivateKey loadPrivateKeyFromPkcs8(String pkcs8Pem) throws GeneralSecurityException {
        Objects.requireNonNull(pkcs8Pem);
        String pem = pkcs8Pem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\r", "").replace("\n", "").trim();
        byte[] privateKeyBytes = Base64.getDecoder().decode(pem);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey loadPublicKeyFromPEM(String pubPem) throws GeneralSecurityException {
        Objects.requireNonNull(pubPem);
        String pem = pubPem.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\r", "").replace("\n", "").trim();
        byte[] publicKeyBytes = Base64.getDecoder().decode(pem);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(publicKeyBytes);
        return keyFactory.generatePublic(keySpec);
    }

    public static PublicKey loadPublicKeyFromX509Certificate(String certPem) throws GeneralSecurityException {
        Objects.requireNonNull(certPem);
        X509Certificate cert = RSAKeyLoader.loadX509Certificate(certPem);
        return cert.getPublicKey();
    }

    public static X509Certificate loadX509Certificate(String certPem) throws GeneralSecurityException {
        Objects.requireNonNull(certPem);
        String base64 = certPem.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replace("\r", "").replace("\n", "").trim();
        byte[] certBytes = Base64.getDecoder().decode(base64);
        ByteArrayInputStream certStream = new ByteArrayInputStream(certBytes);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(certStream);
    }
}

