/*
 * Decompiled with CFR 0.152.
 */
package com.maksupay.paysdk;

import com.maksupay.paysdk.RSAKeyLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaksuPay {
    static final Logger log = LoggerFactory.getLogger(MaksuPay.class);
    public static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_FOOTER = "-----END CERTIFICATE-----";
    public static final String PUB_HEADER = "-----BEGIN PUBLIC KEY-----";
    public static final String PUB_FOOTER = "-----END PUBLIC KEY-----";
    public static final String PRI_HEADER = "-----BEGIN PRIVATE KEY-----";
    public static final String PRI_FOOTER = "-----END PRIVATE KEY-----";

    public String createMaksuPayRequest(String merchantKey, String merchantCert, Map<String, String> requestParams) throws GeneralSecurityException {
        Objects.requireNonNull(merchantKey, "merchantKey is null");
        Objects.requireNonNull(merchantCert, "merchantCert is null");
        Objects.requireNonNull(requestParams, "requestParams is null");
        StringBuilder request = new StringBuilder(2048);
        StringBuilder sigString = new StringBuilder(2048);
        for (IfV5RequestParams param : IfV5RequestParams.values()) {
            String val = requestParams.get(param.name());
            if (val == null || val.isEmpty()) continue;
            if (!request.isEmpty()) {
                request.append("&");
            }
            request.append((Object)param).append("=").append(URLEncoder.encode(val, StandardCharsets.UTF_8));
            sigString.append(val).append(";");
        }
        requestParams.put("signaturebase", sigString.toString());
        byte[] data = sigString.toString().getBytes(StandardCharsets.UTF_8);
        String sig = MaksuPay.calculateSignature(data, merchantKey);
        String pkHash = MaksuPay.publicKeySHA256Hash(merchantCert);
        request.append("signature=").append(URLEncoder.encode(sig, StandardCharsets.UTF_8));
        request.append("publicKeyHash=").append(StringEscapeUtils.escapeHtml4((String)pkHash));
        return request.toString();
    }

    public String createMaksuPayRequestAsForm(String merchantKey, String merchantCert, String maksuURL, Map<String, String> requestParams) throws GeneralSecurityException {
        Objects.requireNonNull(merchantKey, "merchantKey is null");
        Objects.requireNonNull(merchantCert, "merchantCert is null");
        Objects.requireNonNull(maksuURL, "maksuURL is null");
        Objects.requireNonNull(requestParams, "requestParams is null");
        StringBuilder request = new StringBuilder(3072);
        StringBuilder sigString = new StringBuilder(2048);
        request.append("<form id=\"maksuPay\" action=\"").append(maksuURL).append("\" method=\"post\">\n");
        for (IfV5RequestParams param : IfV5RequestParams.values()) {
            String val = requestParams.get(param.name());
            if (val == null || val.isEmpty()) continue;
            request.append("<input type=\"hidden\" name=\"").append(param.name()).append("\" value=\"").append(StringEscapeUtils.escapeHtml4((String)val)).append("\"/>\n");
            sigString.append(val).append(";");
        }
        requestParams.put("signaturebase", sigString.toString());
        byte[] data = sigString.toString().getBytes(StandardCharsets.UTF_8);
        String sig = MaksuPay.calculateSignature(data, merchantKey);
        String pkHash = MaksuPay.publicKeySHA256Hash(merchantCert);
        request.append("<input type=\"hidden\" name=\"signature\" value=\"").append(StringEscapeUtils.escapeHtml4((String)sig)).append("\"/>\n");
        request.append("<input type=\"hidden\" name=\"publicKeyHash\" value=\"").append(StringEscapeUtils.escapeHtml4((String)pkHash)).append("\"/>\n");
        request.append("</form>\n");
        return request.toString();
    }

    public boolean validateResponse(String maksuCerts, Map<String, String> responseParams) {
        Objects.requireNonNull(maksuCerts, "maksuCerts is null");
        Objects.requireNonNull(responseParams, "responseParams is null");
        String pattern = "(-----END CERTIFICATE-----)";
        String[] maksuCertsX = maksuCerts.split(pattern);
        X509Certificate[] maksuCertsX509 = new X509Certificate[maksuCertsX.length];
        for (int i = 0; i < maksuCertsX.length; ++i) {
            try {
                X509Certificate x509;
                maksuCertsX509[i] = x509 = RSAKeyLoader.loadX509Certificate(maksuCertsX[i]);
                continue;
            }
            catch (GeneralSecurityException ex) {
                log.error("validateResponse failed", (Throwable)ex);
            }
        }
        return this.validateResponse(maksuCertsX509, responseParams);
    }

    public boolean validateResponse(X509Certificate[] maksuCerts, Map<String, String> responseParams) {
        Objects.requireNonNull(maksuCerts, "maksuCerts is null");
        Objects.requireNonNull(responseParams, "responseParams is null");
        StringBuilder sigString = new StringBuilder(2048);
        for (IfV5ResponseParams param : IfV5ResponseParams.values()) {
            String val;
            if (!responseParams.containsKey(param.name()) || (val = responseParams.get(param.name())) == null || val.isEmpty()) continue;
            sigString.append(val).append(";");
        }
        responseParams.put("signaturebase", sigString.toString());
        String pkHash = responseParams.get(IfV5SigParams.publicKeyHash.name());
        byte[] data = sigString.toString().getBytes(StandardCharsets.UTF_8);
        byte[] sigBytes = Base64.getDecoder().decode(responseParams.get("signature"));
        for (X509Certificate certX : maksuCerts) {
            String pkHashX = null;
            try {
                pkHashX = MaksuPay.publicKeySHA256Hash(certX);
            }
            catch (GeneralSecurityException ex) {
                log.error("Public key hash failed", (Throwable)ex);
            }
            PublicKey rsaPublicX = certX.getPublicKey();
            if (pkHash != null && pkHash.equals(pkHashX)) {
                responseParams.put("validatedwith", certX.getSubjectX500Principal().getName());
                try {
                    return MaksuPay.validateSignature(rsaPublicX, data, sigBytes);
                }
                catch (GeneralSecurityException ex) {
                    log.error("validateResponse failed", (Throwable)ex);
                    return false;
                }
            }
            try {
                boolean isValidWithX = MaksuPay.validateSignature(rsaPublicX, data, sigBytes);
                if (!isValidWithX) continue;
                return true;
            }
            catch (GeneralSecurityException ex) {
                log.error("validateResponse failed", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    public static String calculateSignature(byte[] data, String privateKey) throws GeneralSecurityException {
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(privateKey, "privateKey is null");
        try {
            PrivateKey key = RSAKeyLoader.loadPrivateKeyFromPkcs8(privateKey);
            Signature sg = Signature.getInstance("SHA256withRSA");
            sg.initSign(key);
            sg.update(data);
            byte[] signature = sg.sign();
            return Base64.getEncoder().encodeToString(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            log.error("calculateSignature error", (Throwable)ex);
            throw new GeneralSecurityException("Signature calculation failed", ex);
        }
    }

    public static HttpResponse<byte[]> sendAPIRequest(String apiURL, int timeout, String merId, PrivateKey merchantKey, X509Certificate merchantCert, byte[] request, StringBuilder requestHeadersDbg) throws GeneralSecurityException, IOException, InterruptedException {
        Objects.requireNonNull(apiURL, "apiURL is null");
        Objects.requireNonNull(merId, "merId is null");
        Objects.requireNonNull(merchantKey, "merchantKey is null");
        Objects.requireNonNull(merchantCert, "merchantCert is null");
        Objects.requireNonNull(request, "request is null");
        String sigHeader = MaksuPay.calculateSignatureForJSONHeader(request, merchantKey);
        String pkHashHeader = MaksuPay.publicKeySHA256Hash(merchantCert);
        HttpRequest httpRequest = HttpRequest.newBuilder().timeout(Duration.ofSeconds(timeout)).header("Content-Type", "application/json").header("X-Payload-Signature", sigHeader).header("X-Public-Key-Hash", pkHashHeader).header("X-Sender-ID", merId).uri(URI.create(apiURL)).POST(HttpRequest.BodyPublishers.ofByteArray(request)).build();
        if (requestHeadersDbg != null) {
            for (Map.Entry<String, List<String>> header : httpRequest.headers().map().entrySet()) {
                if (!requestHeadersDbg.isEmpty()) {
                    requestHeadersDbg.append("\n");
                }
                requestHeadersDbg.append(header.getKey()).append(" = ").append(String.join((CharSequence)",", (Iterable<? extends CharSequence>)header.getValue()));
            }
        }
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpResponse<byte[]> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
            return httpResponse;
        }
    }

    public static HttpResponse<byte[]> sendAPIRequest(String apiURL, int timeout, String merId, PrivateKey merchantKey, X509Certificate merchantCert, Object request, StringBuilder requestHeadersDbg) throws GeneralSecurityException, IOException, InterruptedException {
        return MaksuPay.sendAPIRequest(apiURL, timeout, merId, merchantKey, merchantCert, JsonUtil.toJson(request).getBytes(StandardCharsets.UTF_8), requestHeadersDbg);
    }

    public static HttpResponse<byte[]> sendAPIRequest(String apiURL, int timeout, String merId, String merchantKey, String merchantCert, String request) throws GeneralSecurityException, IOException, InterruptedException {
        return MaksuPay.sendAPIRequest(apiURL, timeout, merId, merchantKey, merchantCert, request, null);
    }

    public static HttpResponse<byte[]> sendAPIRequest(String apiURL, int timeout, String merId, String merchantKey, String merchantCert, String request, StringBuilder requestHeadersDbg) throws GeneralSecurityException, IOException, InterruptedException {
        PrivateKey merchantKeyObj = RSAKeyLoader.loadPrivateKeyFromPkcs8(merchantKey);
        X509Certificate merchantCertObj = RSAKeyLoader.loadX509Certificate(merchantCert);
        return MaksuPay.sendAPIRequest(apiURL, timeout, merId, merchantKeyObj, merchantCertObj, request.getBytes(StandardCharsets.UTF_8), requestHeadersDbg);
    }

    public static String calculateSignatureForJSONHeader(byte[] data, String privateKey) throws GeneralSecurityException {
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(privateKey, "privateKey is null");
        PrivateKey key = RSAKeyLoader.loadPrivateKeyFromPkcs8(privateKey);
        return MaksuPay.calculateSignatureForJSONHeader(data, key);
    }

    public static String calculateSignatureForJSONHeader(byte[] data, PrivateKey privateKey) throws GeneralSecurityException {
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(privateKey, "privateKey is null");
        try {
            Signature sg = Signature.getInstance("SHA256withRSA");
            sg.initSign(privateKey);
            sg.update(data);
            byte[] signature = sg.sign();
            String sigStr = Base64.getEncoder().encodeToString(signature);
            return "RSA-SHA256;" + sigStr;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            log.error("calculateSignatureForJSONHeader error", (Throwable)ex);
            throw new GeneralSecurityException(ex);
        }
    }

    public static boolean validateApiResponse(String maksuCerts, String pkHash, String sigB64, byte[] data) {
        Objects.requireNonNull(maksuCerts, "maksuCerts is null");
        Objects.requireNonNull(pkHash, "pkHash is null");
        Objects.requireNonNull(sigB64, "sigB64 is null");
        Objects.requireNonNull(data, "data is null");
        String pattern = "(-----END CERTIFICATE-----)";
        String[] maksuCertsX = maksuCerts.split(pattern);
        X509Certificate[] maksuCertsX509 = new X509Certificate[maksuCertsX.length];
        for (int i = 0; i < maksuCertsX.length; ++i) {
            try {
                X509Certificate x509;
                maksuCertsX509[i] = x509 = RSAKeyLoader.loadX509Certificate(maksuCertsX[i]);
                continue;
            }
            catch (GeneralSecurityException ex) {
                log.error("validateApiResponse failed", (Throwable)ex);
            }
        }
        return MaksuPay.validateApiResponse(maksuCertsX509, pkHash, sigB64, data);
    }

    public static boolean validateApiResponse(X509Certificate[] maksuCerts, String pkHash, String sigB64, byte[] data) {
        Objects.requireNonNull(maksuCerts, "maksuCerts is null");
        Objects.requireNonNull(pkHash, "pkHash is null");
        Objects.requireNonNull(sigB64, "sigB64 is null");
        Objects.requireNonNull(data, "data is null");
        for (X509Certificate certX : maksuCerts) {
            String pkHashX = null;
            try {
                pkHashX = MaksuPay.publicKeySHA256Hash(certX);
            }
            catch (GeneralSecurityException ex) {
                log.error("Public key hash failed", (Throwable)ex);
            }
            PublicKey rsaPublicX = certX.getPublicKey();
            if (pkHash.equals(pkHashX)) {
                try {
                    return MaksuPay.validateSignatureJSONHeader(rsaPublicX, sigB64, data);
                }
                catch (GeneralSecurityException ex) {
                    log.error("validateApiResponse failed", (Throwable)ex);
                    return false;
                }
            }
            try {
                boolean isValidWithX = MaksuPay.validateSignatureJSONHeader(rsaPublicX, sigB64, data);
                if (!isValidWithX) continue;
                return true;
            }
            catch (GeneralSecurityException ex) {
                log.error("validateApiResponse failed", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    public static String getVersion() {
        Package pkg = MaksuPay.class.getPackage();
        return pkg.getImplementationVersion();
    }

    public static boolean validateSignature(PublicKey publicKey, byte[] data, byte[] signature) throws GeneralSecurityException {
        Objects.requireNonNull(publicKey, "publicKey is null");
        Objects.requireNonNull(data, "data is null");
        Objects.requireNonNull(signature, "signature is null");
        try {
            Signature sg = Signature.getInstance("SHA256withRSA");
            sg.initVerify(publicKey);
            sg.update(data);
            return sg.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            log.error("validateSignature error", (Throwable)ex);
            throw new GeneralSecurityException(ex);
        }
    }

    public static boolean validateSignatureJSONHeader(PublicKey publicKey, String xPayloadSignature, byte[] data) throws GeneralSecurityException {
        Objects.requireNonNull(publicKey, "publicKey is null");
        Objects.requireNonNull(xPayloadSignature, "xPayloadSignature is null");
        Objects.requireNonNull(data, "data is null");
        String algName = "SHA256withRSA";
        if (xPayloadSignature.startsWith("RSA-SHA256;")) {
            algName = "SHA256withRSA";
        } else if (xPayloadSignature.startsWith("RSA-SHA512;")) {
            algName = "SHA512withRSA";
        }
        byte[] signature = Base64.getDecoder().decode(xPayloadSignature.substring(11));
        try {
            Signature sg = Signature.getInstance(algName);
            sg.initVerify(publicKey);
            sg.update(data);
            return sg.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            log.error("validateSignatureJSONHeader error", (Throwable)ex);
            throw new GeneralSecurityException(ex);
        }
    }

    public static String publicKeySHA256Hash(String certificate) throws GeneralSecurityException {
        X509Certificate certX = RSAKeyLoader.loadX509Certificate(certificate);
        return MaksuPay.publicKeySHA256Hash(certX);
    }

    public static String publicKeySHA256Hash(X509Certificate cert) throws GeneralSecurityException {
        PublicKey rsaPublic = cert.getPublicKey();
        byte[] publicKeyBytes = rsaPublic.getEncoded();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] digest = sha256.digest(publicKeyBytes);
        return Base64.getEncoder().encodeToString(digest);
    }

    public static enum IfV5RequestParams {
        version,
        mid,
        lang,
        trType,
        orderid,
        orderDesc,
        orderAmount,
        currency,
        payerName,
        payerEmail,
        payerPhone,
        billCountry,
        billState,
        billZip,
        billCity,
        billAddress,
        shipCountry,
        shipState,
        shipZip,
        shipCity,
        shipAddress,
        weight,
        dimensions,
        addFraudScore,
        maxPayRetries,
        reject3dsU,
        payMethod,
        blockScore,
        cssUrl,
        confirmUrl,
        cancelUrl,
        extInstallmentoffset,
        extInstallmentperiod,
        extRecurringfrequency,
        extRecurringenddate,
        extXOrderId,
        extTokenOptions,
        extToken,
        var1,
        var2,
        var3,
        var4,
        var5,
        var6,
        var7,
        var8,
        var9;

    }

    public static enum IfV5ResponseParams {
        version,
        mid,
        orderid,
        status,
        orderAmount,
        currency,
        paymentTotal,
        message,
        riskScore,
        payMethod,
        txId,
        paymentRef,
        shipCountry,
        shipState,
        shipZip,
        shipCity,
        shipAddress,
        shipRecipientName,
        shipRecipientPhone,
        extToken,
        extTokenPanEnd,
        extTokenExp,
        extData,
        var1,
        var2,
        var3,
        var4,
        var5,
        var6,
        var7,
        var8,
        var9;

    }

    public static enum IfV5SigParams {
        signature,
        publicKeyHash;

    }

    static class JsonUtil {
        JsonUtil() {
        }

        public static String toJson(Object value) {
            if (value == null) {
                return "null";
            }
            if (value instanceof String) {
                String s = (String)value;
                return "\"" + JsonUtil.escape(s) + "\"";
            }
            if (value instanceof Number || value instanceof Boolean) {
                return value.toString();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return JsonUtil.mapToJson(map);
            }
            if (value instanceof Iterable) {
                Iterable list = (Iterable)value;
                return JsonUtil.listToJson(list);
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(value.getClass()));
        }

        private static String mapToJson(Map<?, ?> map) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean first = true;
            for (Map.Entry<?, ?> e : map.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(JsonUtil.toJson(e.getKey().toString()));
                sb.append(":");
                sb.append(JsonUtil.toJson(e.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }

        private static String listToJson(Iterable<?> list) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            boolean first = true;
            for (Object o : list) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(JsonUtil.toJson(o));
            }
            sb.append("]");
            return sb.toString();
        }

        private static String escape(String s) {
            return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
        }
    }

    public static enum IfV5NotificationParams {
        version,
        mid,
        orderid,
        eventType,
        statusBefore,
        status,
        settlStatusBefore,
        settlStatus,
        orderAmount,
        currency,
        paymentTotal,
        payMethod,
        txId,
        paymentRef;

    }
}

