<?php
/**
 * Settings for Maksupay Gateway.
 *
 * @package WooCommerce\Classes\Payment
 */


defined( 'ABSPATH' ) || exit;

return array(
	'enabled'                 => array(
		'title'   => __( 'Enable/Disable', 'gateway-maksupay' ),
		'type'    => 'checkbox',
		'label'   => __( 'Enable Maksupay', 'gateway-maksupay' ),
		'default' => 'no',
	),
	'test_local_mode'         => array(
		'title'   => __( 'Test local mode Enable/Disable', 'gateway-maksupay' ),
		'type'    => 'checkbox',
		'label'   => __( 'Test local', 'gateway-maksupay' ),
		'default' => 'no',
	),
	'debug'                   => array(
		'title'   => __( 'Debug', 'gateway-maksupay' ),
		'type'    => 'checkbox',
		'label'   => __( 'Debug mode', 'gateway-maksupay' ),
		'default' => 'no',
	),
	'title'                   => array(
		'title'       => __( 'Title', 'gateway-maksupay' ),
		'type'        => 'safe_text',
		'description' => __( 'This controls the title which the user sees during checkout.', 'gateway-maksupay' ),
		'default'     => __( 'Maksupay', 'gateway-maksupay' ),
		'desc_tip'    => true,
	),
	'description'             => array(
		'title'       => __( 'Description', 'gateway-maksupay' ),
		'type'        => 'text',
		'desc_tip'    => true,
		'description' => __( 'This controls the description which the user sees during checkout.', 'gateway-maksupay' ),
		'default'     => __( "Pay via Maksupay", 'gateway-maksupay' ),
	),
	'merchant_id'             => array(
		'title'       => __( 'Merchant ID', 'gateway-maksupay' ),
		'type'        => 'text',
		'description' => __( 'Enter your Maksupay Merchant ID here.', 'gateway-maksupay' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'private_key'             => array(
		'title'       => __( 'Private key', 'gateway-maksupay' ),
		'type'        => 'textarea',
		'desc_tip'    => true,
		'description' => __( 'This is needed to sign the payment request to Maksupay', 'gateway-maksupay' ),
		'default'     => '',
	),
	'merchant_certificate'    => array(
		'title'       => __( 'Merchant certificate', 'gateway-maksupay' ),
		'type'        => 'textarea',
		'desc_tip'    => true,
		'description' => __( 'This is needed to send API Requests to Maksupay Gateway', 'gateway-maksupay' ),
		'default'     => '',
	),
	'processor_certificate'   => array(
		'title'       => __( 'Processor certificate', 'gateway-maksupay' ),
		'type'        => 'textarea',
		'desc_tip'    => true,
		'description' => __( 'This is needed to validate the signature from the Maksupay Gateway', 'gateway-maksupay' ),
		'default'     => '',
	),
	'redirect_url'            => array(
		'title'       => __( 'Redirect URL', 'gateway-maksupay' ),
		'type'        => 'text',
		'description' => __( 'Redirect URL where user goes to pay', 'gateway-maksupay' ),
		'default'     => "",
		'desc_tip'    => true,
	),
	'api_url'                 => array(
		'title'       => __( 'API URL', 'gateway-maksupay' ),
		'type'        => 'text',
		'description' => __( 'API URL', 'gateway-maksupay' ),
		'default'     => "",
		'desc_tip'    => true,
	),
	'available_currencies'    => array(
		'title'       => __( 'Available currencies list', 'gateway-maksupay' ),
		'type'        => 'text',
		'description' => __( 'Currencies list seperated by `,`', 'gateway-maksupay' ),
		'default'     => "EUR, USD",
		'desc_tip'    => true,
	),
	'test_local_callback_url' => array(
		'title'       => __( 'Callback URL (only on local environment)', 'gateway-maksupay' ),
		'type'        => 'text',
		'description' => __( 'Callback URL', 'gateway-maksupay' ),
		'default'     => "",
		'desc_tip'    => true,
	),
);
