<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

class Gateway_Maksupay_Block_Support extends AbstractPaymentMethodType {
	protected $name = 'maksupay';

	public function initialize() {
		require_once __DIR__ . '/../class-gateway-maksupay.php';
		$maksupay       = new Gateway_Maksupay();
		$this->settings = [
			'title'       => $maksupay->get_title(),
			'description' => $maksupay->get_description(),
			'supports'    => $maksupay->supports,
			'enabled'     => $maksupay->is_available(),
		];
	}

	public function is_active() {
		return filter_var( $this->get_setting( 'enabled', false ), FILTER_VALIDATE_BOOLEAN );
	}

	/**
	 * Returns an array of scripts/handles to be registered for this payment method.
	 *
	 * @return array
	 */
	public function get_payment_method_script_handles() {
		return [ 'maksupay-gateway-block-script' ];
	}

	/**
	 * Returns an array of key=>value pairs of data made available to the payment methods script.
	 *
	 * @return array
	 */
	public function get_payment_method_data() {
		return [
			'title'       => $this->get_setting( 'title' ),
			'description' => $this->get_setting( 'description' ),
			'supports'    => $this->get_setting( 'supports' ),
		];
	}
}