<?php
/**
 * Plugin Name: Maksupay Gateway for WooCommerce
 * Plugin URI: https://maksupay.com/
 * Description: Online Payments You Trust from the Heart of Europe. Maksu enables businesses to receive and manage online payments efficiently and securely. Whether you are a small business, startup, or a large enterprise, our cutting-edge processing engine is designed to deliver maximum value for every payment. Plugin for WooCommerce
 * Version: 1.0
 * Author: Almat Nygmanov for Maksupay.com
 * Author URI: https://maksupay.com/
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
function maksupay_gateway_init() {
	require_once __DIR__ . '/class-gateway-maksupay.php';
}

add_action( 'plugins_loaded', 'maksupay_gateway_init' );

function add_maksupay_gateway_class( $methods ) {
	$methods[] = 'Gateway_Maksupay';

	return $methods;
}

add_filter( 'woocommerce_payment_gateways', 'add_maksupay_gateway_class' );

function maksupay_add_query_vars( $vars ) {
	$vars[] = 'maksupay_redirect_order_id';
	$vars[] = 'maksupay_confirm_order_id';
	$vars[] = 'maksupay_cancel_order_id';

	return $vars;
}

add_filter( 'query_vars', 'maksupay_add_query_vars' );

function parse_order_id( $order_id ) {
	$order_id = str_replace( 'WO', '', $order_id );
	$order_id = substr( $order_id, 0, - 3 );
	$order_id = ltrim( $order_id, '0' );

	return $order_id;
}

function maksupay_redirect_handler() {
	if ( get_query_var( 'maksupay_redirect_order_id' ) ) {
		$order_id = get_query_var( 'maksupay_redirect_order_id' );
		( new Gateway_Maksupay )->redirect_handler( $order_id );
	}
}

function maksupay_confirm_handler() {
	if ( get_query_var( 'maksupay_confirm_order_id' ) ) {
		$order_id = get_query_var( 'maksupay_confirm_order_id' );
		( new Gateway_Maksupay )->confirm_handler( parse_order_id( $order_id ) );
	}
}

function maksupay_cancel_handler() {
	if ( get_query_var( 'maksupay_cancel_order_id' ) ) {
		$order_id = get_query_var( 'maksupay_cancel_order_id' );
		( new Gateway_Maksupay )->cancel_handler( parse_order_id( $order_id ) );
	}
}

add_action( 'template_redirect', 'maksupay_redirect_handler' );
add_action( 'template_redirect', 'maksupay_confirm_handler' );
add_action( 'template_redirect', 'maksupay_cancel_handler' );

add_action(
	'woocommerce_blocks_payment_method_type_registration',
	function ( \Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
		require_once __DIR__ . '/includes/class-gateway-maksupay-block-support.php';
		$payment_method_registry->register( new Gateway_Maksupay_Block_Support() );
	}
);
function enqueue_maksupay_blocks_scripts() {
	wp_register_script(
		'maksupay-gateway-block-script',
		plugin_dir_url( __FILE__ ) . '/assets/js/blocks/maksupay.js',
		[ 'wc-blocks-registry', 'wp-element', 'wp-html-entities', 'wp-i18n' ],
		'1.0.0',
		true
	);
}

add_action( 'enqueue_block_assets', 'enqueue_maksupay_blocks_scripts' );