import * as paymentProvider from 'interfaces-psp-v1-payment-service-provider';

/** @returns {import('interfaces-psp-v1-payment-service-provider').PaymentServiceProviderConfig} */
export function getConfig() {
  return {
    title: "MaksuPay",
    paymentMethods: [
      {
        hostedPage: {
          title: "MaksuPay",
          billingAddressMandatoryFields: [],
          logos: {
            white: {
              svg: "https://maksupay.com/wp-content/uploads/2024/11/Group-134.pn",
              png: "https://maksupay.com/wp-content/uploads/2024/11/Group-134.png",
            },
            colored: {
              svg: "https://maksupay.com/wp-content/uploads/2024/11/Component-11.png",
              png: "https://maksupay.com/wp-content/uploads/2024/11/Component-11.png",
            },
          },
        },
      },
    ],
    credentialsFields: [
      {
        simpleField: {
          name: "mid",
          label: "Merchant ID"
        }
      },
      {
        simpleField: {
          name: "domain",
          label: "Domain Name"
        }
      },
      {
        simpleField: {
          name: "paymentServiceUrl",
          label: "Payment Service URL"
        }
      },
      {
        simpleField: {
          name: "refundServiceUrl",
          label: "Refund Service URL"
        }
      },
    ],
  };
}
