<?php
/**
 * PrestaShop Maksupay Payment Module
 *
 * @author Maksupay Team
 * @copyright Maksupay
 * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class MaksupayConfirmationModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        $orderId = Tools::getValue('order_id');
        // Find order by reference
        $order = new Order((int) $orderId);
        if (!$order->id) {
            $this->exit($order, $this->trans('Something went wrong', [], 'Modules.Maksupay.Front'));

            return;
        }

        try {
            $status = Tools::getValue('status');
            $signature = Tools::getValue('signature');

            if (!$signature) {
                throw new PrestaShopException('Missing or invalid signature');
            } else {
                $this->validateCallback($order, Tools::getAllValues());
            }

            // Update order status based on payment result
            if (in_array($status, ['AUTHORIZED', 'CAPTURED', 'COMPLETED'])) {
                $order->setCurrentState((int) Configuration::get('PS_OS_PAYMENT'));
            } else {
                $order->setCurrentState((int) Configuration::get('PS_OS_ERROR'));
                $this->exit($order, $this->trans('Payment was not confirmed', [], 'Modules.Maksupay.Front'));

                return;
            }

            // Redirect to order confirmation page
            Tools::redirect(
                'index.php?controller=order-confirmation&id_cart=' . $order->id_cart . '&id_module=' . $this->module->id . '&id_order=' . $order->id . '&key=' . $order->secure_key
            );
        } catch (Exception $e) {
            PrestaShopLogger::addLog(
                'Signature validation error: ' . $e->getMessage(),
                PrestaShopLogger::LOG_SEVERITY_LEVEL_ERROR
            );
            Tools::redirect(
                'index.php?controller=order&step=1&payment_error=1&error_message=' . urlencode(
                    $this->trans('Something went wrong', [], 'Modules.Maksupay.Front')
                )
            );

            $this->exit($order, $this->trans('Something went wrong', [], 'Modules.Maksupay.Front'));

            return;
        }
    }

    protected function restoreCart($order)
    {
        $oldCart = new Cart($order->id_cart);
        if (Validate::isLoadedObject($oldCart)) {
            $duplication = $oldCart->duplicate();
            if ($duplication && isset($duplication['cart'])) {
                $newCart = $duplication['cart'];
                /**
                 * @var CookieExtended $cookie
                 */
                $cookie = $this->context->cookie;
                $cookie->id_cart = $newCart->id;
                $cookie->write();
            }
        }
    }

    protected function exit($order, string $message)
    {
        if ($order) {
            $this->restoreCart($order);
        }
        $this->context->smarty->assign([
            'error_message' => $message,
        ]);

        $this->setTemplate('module:maksupay/views/templates/front/cancel.tpl');
    }

    /**
     * Validate callback signature
     */
    protected function validateCallback($order, $data)
    {
        require_once _PS_MODULE_DIR_ . '/maksupay/classes/signature.php';
        require_once _PS_MODULE_DIR_ . '/maksupay/classes/cookie.php';

        $processorCert = Configuration::get('MAKSUPAY_PROCESSOR_CERT');
        $signature = $data['signature'];

        $signatureValidator = new MaksupaySignature();
        $isValid = $signatureValidator->isValidIpnSignature($data, $processorCert, $signature);

        if (!$isValid) {
            throw new Exception('Invalid signature');
        }
    }
}
