<?php
/**
 * PrestaShop Maksupay Payment Module
 *
 * @author Maksupay Team
 * @copyright Maksupay
 * @license https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class MaksupayCancelModuleFrontController extends ModuleFrontController
{
    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        try {
            parent::initContent();

            $orderId = Tools::getValue('order_id');
            if (!empty($orderId)) {
                $order = new Order((int) $orderId);
                $this->restoreCart($order);

                $signature = Tools::getValue('signature');

                if (!$signature) {
                    throw new PrestaShopException('Missing or invalid signature');
                } else {
                    $this->validateCallback($order, Tools::getAllValues());
                }

                $order->setCurrentState((int) Configuration::get('PS_OS_CANCELED'));
            }

            $this->context->smarty->assign([
                'error_message' => $this->trans('Payment was cancelled', [], 'Modules.Maksupay.Front'),
            ]);

            $this->setTemplate('module:maksupay/views/templates/front/cancel.tpl');
        } catch (Exception $e) {
            PrestaShopLogger::addLog(
                'Something went wrong order_id=' . $orderId . ' message=' . $e->getMessage(),
                PrestaShopLogger::LOG_SEVERITY_LEVEL_ERROR
            );
            $this->context->smarty->assign([
                'error_message' => $this->trans('Something went wrong', [], 'Modules.Maksupay.Front'),
            ]);

            $this->setTemplate('module:maksupay/views/templates/front/cancel.tpl');
        }
    }

    protected function restoreCart($order)
    {
        $oldCart = new Cart($order->id_cart);
        if (Validate::isLoadedObject($oldCart)) {
            $duplication = $oldCart->duplicate();
            if ($duplication && isset($duplication['cart'])) {
                $newCart = $duplication['cart'];
                $this->context->cart = $newCart;
                /**
                 * @var CookieExtended $cookie
                 */
                $cookie = $this->context->cookie;
                $cookie->id_cart = $newCart->id;
                $cookie->write();
            }
        }
    }

    /**
     * Validate callback signature
     */
    protected function validateCallback($order, $data)
    {
        require_once _PS_MODULE_DIR_ . '/maksupay/classes/signature.php';
        require_once _PS_MODULE_DIR_ . '/maksupay/classes/cookie.php';

        $processorCert = Configuration::get('MAKSUPAY_PROCESSOR_CERT');
        $signature = $data['signature'];

        $signatureValidator = new MaksupaySignature();
        $isValid = $signatureValidator->isValidIpnSignature($data, $processorCert, $signature);

        if (!$isValid) {
            throw new Exception('Invalid signature');
        }
    }
}
